
#include "XorShift.h"

// global state
static unsigned int xorShift_x = 123456789u;
static unsigned int xorShift_y = 362436069u;
static unsigned int xorShift_z = 521288629u;
static unsigned int xorShift_w = 88675123u;


unsigned int Random::XorShift(void)
{
	const unsigned int t = xorShift_x ^ (xorShift_x << 11u);
	xorShift_x = xorShift_y;
	xorShift_y = xorShift_z;
	xorShift_z = xorShift_w;
	xorShift_w ^= (xorShift_w >> 19u) ^ (t ^ (t >> 8u));

	return xorShift_w;
}


unsigned int Random::XorShift(unsigned int minValue, unsigned int maxValue)
{
	const unsigned int range = maxValue - minValue;
	const unsigned int randomNumber = XorShift();

	return ((randomNumber % range) + minValue);
}
