
#include "Mutex.h"


Mutex::Mutex(void)
{
	::InitializeCriticalSection(&m_cs);
}


Mutex::~Mutex(void)
{
	::DeleteCriticalSection(&m_cs);
}


void Mutex::Enter(void)
{
	::EnterCriticalSection(&m_cs);
}


void Mutex::Leave(void)
{
	::LeaveCriticalSection(&m_cs);
}


Mutex::ScopedLock::ScopedLock(Mutex* mutex)
	: m_mutex(mutex)
{
	m_mutex->Enter();
}


Mutex::ScopedLock::~ScopedLock(void)
{
	m_mutex->Leave();
}
