
#include "FrameBuffer.h"


// Live++: plugin render function
extern "C" __declspec(dllexport) void __cdecl PluginRender(unsigned int width, unsigned int height, unsigned char* rgbaBuffer)
{
	const unsigned int pixelCount = width * height;

	for (unsigned int i = 0u; i < pixelCount; ++i)
	{
		const unsigned char r = rgbaBuffer[i * 4u + FrameBuffer::RGBAIndex::Red];
		const unsigned char g = rgbaBuffer[i * 4u + FrameBuffer::RGBAIndex::Green];
		const unsigned char b = rgbaBuffer[i * 4u + FrameBuffer::RGBAIndex::Blue];

		// convert RGB to grayscale: luminosity = r*0.3 + g*0.59 + b*0.11;
		const unsigned char luminosity = (static_cast<unsigned int>(r) * 77u + static_cast<unsigned int>(g) * 151u + static_cast<unsigned int>(b) * 28u) >> 8u;

		rgbaBuffer[i * 4u + FrameBuffer::RGBAIndex::Red] = luminosity;
		rgbaBuffer[i * 4u + FrameBuffer::RGBAIndex::Green] = luminosity;
		rgbaBuffer[i * 4u + FrameBuffer::RGBAIndex::Blue] = luminosity;
	}
}
