
#include "MainLoop.h"

// Live++ API
#include "LivePP/API/x64/LPP_API_x64_CPP.h"


// main entry point
int main(void)
{
	// create a synchronized Live++ agent, loading the required project preferences.
	// the path to load the preferences from can be absolute, or relative to this application.
	lpp::LppSynchronizedAgent lppAgent = lpp::LppCreateSynchronizedAgentWithPreferencesFromFile(nullptr, L"../../../LivePP", L"../../02_continuous_compilation.json");
	if (!lpp::LppIsValidSynchronizedAgent(&lppAgent))
	{
		return 1;
	}

	lppAgent.EnableModule(lpp::LppGetCurrentModulePath(), lpp::LPP_MODULES_OPTION_NONE, nullptr, nullptr);

	// init the example
	MainLoop::Init("Example 02: ContinuousCompilation");
	MainLoop::Announce(lppAgent, "../../readme/README_ContinuousCompilation.txt");

	while (MainLoop::PollInput(lppAgent))
	{
		// listen to hot-reload and hot-restart requests
		if (lppAgent.WantsReload(lpp::LPP_RELOAD_OPTION_SYNCHRONIZE_WITH_RELOAD))
		{
			// Live++: client code can do whatever it wants here, e.g. synchronize across several threads, the network, etc.
			lppAgent.Reload(lpp::LPP_RELOAD_BEHAVIOUR_WAIT_UNTIL_CHANGES_ARE_APPLIED);
		}

		if (lppAgent.WantsRestart())
		{
			// Live++: client code can do whatever it wants here, e.g. finish logging, abandon threads, etc.
			lppAgent.Restart(lpp::LPP_RESTART_BEHAVIOUR_INSTANT_TERMINATION, 0u, nullptr);
		}

		// run the main loop
		MainLoop::Update();
		MainLoop::Render();
		MainLoop::Present();
	}

	MainLoop::Exit();

	lpp::LppDestroySynchronizedAgent(&lppAgent);

	return 0;
}
