
#include <Windows.h>

#if DEBUG_BUILD
static const char* const NativeModuleFilename = "13_ArbitraryTargetNativeModule_Debug.dll";
#else
static const char* const NativeModuleFilename = "13_ArbitraryTargetNativeModule_Release.dll";
#endif


// main entry point
int main(void)
{
	// Live++: note that this target application knows absolutely nothing about Live++, and yet hot-reload for the native module will work as expected

	// load the native module
	HMODULE nativeModule = ::LoadLibraryA(NativeModuleFilename);

	// startup the module
	{
		using NativeModuleStartupFunction = void __cdecl (void);
		NativeModuleStartupFunction* nativeModuleStartupFunction = reinterpret_cast<NativeModuleStartupFunction*>(::GetProcAddress(static_cast<HMODULE>(nativeModule), "NativeModuleStartup"));

		nativeModuleStartupFunction();
	}

	// run the per-frame function of the native module
	{
		using NativeModuleFrameFunction = bool __cdecl (void);
		NativeModuleFrameFunction* nativeModuleFrameFunction = reinterpret_cast<NativeModuleFrameFunction*>(::GetProcAddress(static_cast<HMODULE>(nativeModule), "NativeModuleFrame"));

		while (nativeModuleFrameFunction())
		{
			// do nothing
		}
	}

	// shutdown the module
	{
		using NativeModuleShutdownFunction = void __cdecl (void);
		NativeModuleShutdownFunction* nativeModuleShutdownFunction = reinterpret_cast<NativeModuleShutdownFunction*>(::GetProcAddress(static_cast<HMODULE>(nativeModule), "NativeModuleShutdown"));

		nativeModuleShutdownFunction();
	}

	// unload the native module
	::FreeLibrary(nativeModule);

	return 0;
}
