
#pragma once

class PalettizedFrameBuffer;
class Palette;


class FrameBuffer
{
public:
	struct RGBAIndex
	{
		enum Enum
		{
			Blue = 0u,
			Green = 1u,
			Red = 2u,
		};
	};

	explicit FrameBuffer(unsigned int width, unsigned int height);
	~FrameBuffer(void);

	void FillFromPalettizedFrameBuffer(const PalettizedFrameBuffer* palettizedFrameBuffer, const Palette* palette);

	inline unsigned int GetWidth(void) const
	{
		return m_width;
	}

	inline unsigned int GetHeight(void) const
	{
		return m_height;
	}

	inline unsigned char* GetRGBABuffer(void)
	{
		return m_rgbaBuffer;
	}

private:
	unsigned int m_width;
	unsigned int m_height;
	unsigned char* m_rgbaBuffer;
};
