
#include "FrameBuffer.h"
#include "PalettizedFrameBuffer.h"
#include "Palette.h"


FrameBuffer::FrameBuffer(unsigned int width, unsigned int height)
	: m_width(width)
	, m_height(height)
	, m_rgbaBuffer(new unsigned char[width * height * 4u]())
{
}


FrameBuffer::~FrameBuffer(void)
{
	delete[] m_rgbaBuffer;
}


void FrameBuffer::FillFromPalettizedFrameBuffer(const PalettizedFrameBuffer* palettizedFrameBuffer, const Palette* palette)
{
	const unsigned int pixelCount = m_width * m_height;

	const unsigned char* const sourceData = palettizedFrameBuffer->GetData();
	const RGB* const paletteData = palette->GetData();

	for (unsigned int i = 0u; i < pixelCount; ++i)
	{
		const unsigned char paletteIndex = sourceData[i];
		m_rgbaBuffer[i * 4u + RGBAIndex::Red] = paletteData[paletteIndex].r;
		m_rgbaBuffer[i * 4u + RGBAIndex::Green] = paletteData[paletteIndex].g;
		m_rgbaBuffer[i * 4u + RGBAIndex::Blue] = paletteData[paletteIndex].b;
	}
}
