
#pragma once

// forward declare the internal Windows handle type
struct HWND__;
class FrameBuffer;


class Window
{
public:
	explicit Window(const char* windowTitle, FrameBuffer* frameBuffer);
	~Window(void);

	bool PollMessages(void) const;

	void Present(void) const;

	int GetPositionX(void) const;
	int GetPositionY(void) const;
	int GetWidth(void) const;
	int GetHeight(void) const;

	inline FrameBuffer* GetFrameBuffer(void)
	{
		return m_frameBuffer;
	}

private:
	FrameBuffer* m_frameBuffer;
	HWND__* m_windowHandle;
};
