
#pragma once

struct Point2;


class PalettizedFrameBuffer
{
public:
	explicit PalettizedFrameBuffer(unsigned int width, unsigned int height);
	~PalettizedFrameBuffer(void);

	void SpawnFire(void);
	void AverageAndShiftUpwards(void);
	void FadeOut(void);
	void DrawLine(const Point2& p0, const Point2& p1);

	inline unsigned int GetWidth(void) const
	{
		return m_width;
	}

	inline unsigned int GetHeight(void) const
	{
		return m_height;
	}

	inline const unsigned char* GetData(void) const
	{
		return m_buffer;
	}

private:
	void WritePixel(unsigned int x, unsigned int y, unsigned char value);
	unsigned char ReadPixel(unsigned int x, unsigned int y) const;

	unsigned int m_width;
	unsigned int m_height;
	unsigned char* m_buffer;
	unsigned char* m_tempBuffer;
};
