
#pragma once


class Input
{
public:
	enum class Type : int
	{
		HotReload = 0x70,		// VK_F1
		HotRestart = 0x71,		// VK_F2
		LoadPlugin = 'L',
		UnloadPlugin = 'U'
	};

	explicit Input(Type type);

	void Poll(void);
	void Next(void);

	inline bool WentDown(void) const
	{
		return m_isPressed && (!m_wasPressed);
	}

private:
	int m_key;
	bool m_wasPressed;
	bool m_isPressed;
};
