
#pragma once

// Live++: change this #define to 1 to simulate adding a member and recreating the FireDemo instance
#define LPP_DEMONSTRATE_HOOKS 0

#include "PalettizedFrameBuffer.h"
#include "Palette.h"
#include "Cube.h"


class FireDemo
{
public:
	explicit FireDemo(unsigned int width, unsigned int height);

	void Update(float deltaTime);
	void Render(void);

	inline const PalettizedFrameBuffer* GetPalettizedFrameBuffer(void) const
	{
		return &m_palettizedFrameBuffer;
	}

	inline const Palette* GetPalette(void) const
	{
		return &m_palette;
	}

private:
	float m_accumulatedTime;

	PalettizedFrameBuffer m_palettizedFrameBuffer;
	Palette m_palette;
	Cube m_leftCube;
	Cube m_rightCube;

#if LPP_DEMONSTRATE_HOOKS
	Cube m_middleCube;
#endif
};
